Function GetCurrentScreenCloudBrightSignPlayerVersion() As String
  defaultDrive = GetDefaultDrive()
  versionFile = CreateObject("roReadFile", defaultDrive + "app/version.txt")
  LogX("GetCurrentScreenCloudBrightSignPlayerVersion", "versionFile type: " + Type(versionFile))
  If Type(versionFile) = "roReadFile" Then
    Return versionFile.ReadLine().Trim()
  Else ' File is not existed
    Return "version.txt not found"
  End If
End Function

Function GetServerReleaseJson() As Object
  ' TODO: Need to test if the server is not reachable, player crashes? | expected: just skip the ota
  ' TODO: support multiple environments build
  conn = CreateObject("roUrlTransfer")
  url = "https://release.screen.cloud/player/brightsign/production/release.json"
  conn.SetUrl(url)
  data = conn.GetToString()
  Return ParseJson(data)
End Function

' ref: https://www.notion.so/screencloud/BrightSign-Player-current-f9d709cba1834897b7547500239011d1
Function ShouldDoOTAUpdate() As Boolean
  If IsLocalDevelopment() Then
      Return False
  End If

' Check if the current running version includes "local" or "beta"
  currentVersion = GetCurrentScreenCloudBrightSignPlayerVersion()
  If InStr(currentVersion, "local") > 0 Then
      Return False
  End If

  serverReleaseJson = GetServerReleaseJson()
  If IsInvalid(serverReleaseJson) Then ' Fetch json fail
    Return False
  End If

  ' TODO: isValidSpaceToStageRollout -> isValidOrgToStageRollout -> isValidRegion(EU/US)
  _isValidBucketToStageRollout = IsValidBucketToStageRollout(serverReleaseJson)
  _isNotTheSameVersionWithServer = IsNotTheSameVersionWithServer(serverReleaseJson)

  LogX("ShouldDoOTAUpdate", "_isValidBucketToStageRollout: " + ToString(_isValidBucketToStageRollout) + " AND _isNotTheSameVersionWithServer: " + ToString(_isNotTheSameVersionWithServer))
  Return _isValidBucketToStageRollout AND _isNotTheSameVersionWithServer
End Function

Function IsNotTheSameVersionWithServer(serverReleaseJson As Object) As Boolean
  If IsInvalid(serverReleaseJson.version) Then  ' object.version is not existed
    Return False
  End If

  Return (GetCurrentScreenCloudBrightSignPlayerVersion().Trim() <> serverReleaseJson.version.Trim())
End Function

Function IsValidBucketToStageRollout(serverReleaseJson As Object) As Boolean
  ' NOTE: This function will be changed to fetch the calculation from backend instead

  If IsInvalid(serverReleaseJson.stagingPercentage) Then ' object.stagingPercentage is not existed
    Return False
  End If

  serverStagingPercentage = ToNumber(serverReleaseJson.stagingPercentage)
  If NOT IsNumber(serverStagingPercentage) Then
    Return False
  End If

  Return GetRolloutPercentageBucket() <= serverStagingPercentage
End Function

' TODO: maybe we should write the bucket into file then we can grab and add as attributes in DataDog
Function GetRolloutPercentageBucket() As Integer
    deviceUniqueId = CreateObject("roDeviceInfo").GetDeviceUniqueId() ' eg. R4D69C001115, D7E87M002950

    arr = CreateObject("roByteArray")
    arr.FromAsciiString(deviceUniqueId)

    sum = 0
    for each ascii in arr
        sum = sum + ascii
    end for

    if sum = 0 then
      sum = 100
    end if

    bucket = sum MOD 101

    LogX("GetRolloutPercentageBucket", "deviceUniqueId: " + deviceUniqueId + " bucket: " + ToString(bucket))
    Return ToNumber(bucket)
End Function

Sub DownloadAssetAndUnpack()
  defaultDrive = GetDefaultDrive()
  CreateDirectory(defaultDrive + "update")
  zipFileName = GetServerReleaseJson().file
  zipFileDownloadDestination = defaultDrive + "update/" + zipFileName

  r = CreateObject("roRegex", ".zip", "i")
  unZipFolderName = r.Replace(zipFileName,"")

  LogX("DownloadAssetAndUnpack", "Before Version: " + GetCurrentScreenCloudBrightSignPlayerVersion())

  LogX("DownloadAssetAndUnpack", "Trying to download asset" + zipFileDownloadDestination)
  conn = CreateObject("roUrlTransfer")
  url = "https://release.screen.cloud/player/brightsign/production/assets/" + zipFileName
  conn.SetUrl(url)
  conn.GetToFile(zipFileDownloadDestination)
  LogX("DownloadAssetAndUnpack", "Downloaded, trying to unpack")

  package = CreateObject("roBrightPackage", zipFileDownloadDestination)
  package.Unpack(defaultDrive + "update/")
  package = 0
  LogX("DownloadAssetAndUnpack", "Unpacked")
  ' Expect unpack to `sd:/update/autorun.brs`, `sd:/update/app/*`
  MoveFile(defaultDrive + "update/autorun.brs", defaultDrive + "autorun.brs")

  DeleteDirectory(defaultDrive + "app") ' delete app folder first
  LogX("DownloadAssetAndUnpack", "'app' folder deleted")
  MoveFile(defaultDrive + "update/app", defaultDrive +"app")

  LogX("DownloadAssetAndUnpack", "After Version: " + GetCurrentScreenCloudBrightSignPlayerVersion())
  DeleteDirectory("update")
  LogX("DownloadAssetAndUnpack", "Deleted 'update' directory")
End Sub

Sub CheckReleaseAndUpdate(player, maintenance)
  print "start checking update: "; Uptime(0)
  if ShouldDoOTAUpdate() then
    player.Hide()
    maintenance.Show()
    LogX("CheckReleaseAndUpdate", "start to Download and Unpack")
    DownloadAssetAndUnpack()
    LogX("CheckReleaseAndUpdate", "Restarting Application...")
    RestartApplication()
  end if
End Sub