Sub LogX(caller as String, message="" as Dynamic, arg1="" as Dynamic)
  formattedLogMessage = CreateObject("roSystemTime").GetUtcDateTime().GetString() + "Z" + ": [" + caller + "] " + ToString(message) + " " + ToString(arg1)
  Print formattedLogMessage

  ' Also log to file so we can inspect it later
  ' TODO: Clean the log file, if it's too large
  logFile = CreateObject("roAppendFile", GetDefaultDrive() + "ScreenCloudPlayer.log")
  logFile.SendLine(formattedLogMessage)
End Sub

Function ToString(variable As Dynamic) As String
    If Type(variable) = "roInt" Or Type(variable) = "roInteger" Or Type(variable) = "Integer" Or Type(variable) = "roFloat" Or Type(variable) = "Float" Then
        Return Str(variable).Trim()
    Else If Type(variable) = "roBoolean" Or Type(variable) = "Boolean" Then
        If variable = True Then
            Return "True"
        End If
        Return "False"
    Else If Type(variable) = "roString" Or Type(variable) = "String" Then
        Return variable
    Else If Type(variable) = "roAssociativeArray" Or Type(variable) = "AssociativeArray" Then
        Return FormatJson(variable)
    Else If Type(variable) = "roArray" Or Type(variable) = "Array" Then
        Return FormatJson(variable)
    Else
        Return Type(variable)
    End If
End Function

Function ToNumber(variable As Dynamic) As Integer
    If Type(variable) = "roInt" Or Type(variable) = "roInteger" Or Type(variable) = "Integer" Or Type(variable) = "roFloat" Or Type(variable) = "Float" Then
        Return variable
    Else If Type(variable) = "roBoolean" Or Type(variable) = "Boolean" Then
        If variable = True Then
            Return 1
        End If
        Return 0
    Else If Type(variable) = "roString" Or Type(variable) = "String" Then
        Return variable.ToInt()
    Else
        Return Type(variable)
    End If
End Function

Function ToFloat(variable As Dynamic) As Float
    If Type(variable) = "roFloat" Or Type(variable) = "Float" Then
        Return variable
    Else If Type(variable) = "roBoolean" Or Type(variable) = "Boolean" Then
        If variable = True Then
            Return 1.0
        End If
        Return 0.0
    Else If Type(variable) = "roInt" Or Type(variable) = "roInteger" Or Type(variable) = "Integer" Then
        Return ToFloat(ToString(variable))
    Else If Type(variable) = "roString" Or Type(variable) = "String" Then
        Return variable.ToFloat()
    Else
        Return Type(variable)
    End If
End Function

Function IsNumber(variable As Dynamic) As Boolean
    If Type(variable) = "roInt" Or Type(variable) = "roInteger" Or Type(variable) = "Integer" Or Type(variable) = "roFloat" Or Type(variable) = "Float" Then
        Return True
    End If

    Return False
End Function

Function IsInvalid(variable As Dynamic) As Boolean
    If Type(variable) = "Invalid" Or Type(variable) = "roInvalid" Then
        Return True
    End If

    Return False
End Function

Sub EnableSSHAndSFTP()
    ' Enable SSH/TELNET/SFTP
    reg = CreateObject("roRegistrySection", "networking")
    reg.Write("ssh","22")
    reg.Write("telnet","23")

    n=CreateObject("roNetworkConfiguration", 0)

    n.SetLoginPassword("password")
    n.Apply()
    reg.flush()
End Sub

Function IsProduction() As Boolean
    If "production" = "production" Then
        Return True
    Else
        Return False
    End If
End Function

' Some of features could be disabled according to .env.development eg. OTA-update for local development purpose
Function IsLocalDevelopment() As Boolean
    If "production" = "development" Then
        Return True
    Else
        Return False
    End If
End Function

Sub ClearCache()
    defaultDrive = GetDefaultDrive()
    LogX("Autorun", "Deleting html_storage, localproxy, mediacache, screenshots folders")
    DeleteDirectory(defaultDrive + "html_storage")
    DeleteDirectory(defaultDrive + "localproxy")
    DeleteDirectory(defaultDrive + "mediacache")
    DeleteDirectory(defaultDrive + "screenshots")
    Sleep(5000)
    LogX("Autorun", "Creating html_storage, localproxy, mediacache, screenshots folders")
    CreateDirectory(defaultDrive + "html_storage")
    CreateDirectory(defaultDrive + "localproxy")
    CreateDirectory(defaultDrive + "mediacache")
    CreateDirectory(defaultDrive + "screenshots")
End Sub